<?php
$user = \Auth::user();
?>

<?php $__env->startPush('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/usa.css')); ?>">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/swiper.css')); ?>">

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <!-- <div class="breadcrum">
        <a href="">
            <h3>Home /</h3>
        </a>
        <a href="">
            <h3>Destinations /</h3>
        </a>
        <a href="">
            <h3>Australia</h3>
        </a>
    </div> -->

    <div class="banner">
        <h1>Epic <span>Australia</span> tour holidays</h1>
        <img src="<?php echo e(asset('assets/front/images/aus.jpeg')); ?>" alt="">
    </div>

    <div class="country-banner-slider">
        <div class="banner-text-cont">
            <div class="iamge-slider">
                <div class="swiper mySwiper">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide"><img src="<?php echo e(asset('assets/front/images/aus1.webp')); ?>" alt=""></div>
                        <div class="swiper-slide"><img src="<?php echo e(asset('assets/front/images/aus2.webp')); ?>" alt=""></div>
                        <div class="swiper-slide"><img src="<?php echo e(asset('assets/front/images/aus3.webp')); ?>" alt=""></div>
                        <div class="swiper-slide"><img src="<?php echo e(asset('assets/front/images/aus4.webp')); ?>" alt=""></div>
                        <div class="swiper-slide"><img src="<?php echo e(asset('assets/front/images/aus5.webp')); ?>" alt=""></div>
                    </div>
                </div>

            </div>

            <div class="text-content">
                <p id="text">
                    An ancient landscape with over 50,000 years of indigenous culture, jaw-dropping coastlines and laidback charm, there is nowhere else like Australia. Our Australia tours have been designed so that you can immerse yourselves in this wonderfully diverse country - a destination that ticks off natural wonders, iconic sites and quirky wildlife (as well as some extraordinary beaches).

                    <span id="ellipsis">...</span>
                    <span id="extraText" style="display: none;">
                        Enjoy an urban escape in cosmopolitan cities including Sydney, Melbourne and Perth. Sip delicious wines in Australia’s prestigious wine regions, from Hunter Valley in New South Wales to Yarra Valley in Victoria. And perhaps sample a few unusual dishes using native ingredients found nowhere else on Earth.

                        Ultimate Australia holidays would also need to include a trip to the dramatic Outback. We’ll take you to ochre lands where you can indulge your adventurous spirit and explore Uluru and Kata Tjuta National Park. You’ll discover the Whitsunday Islands and enter the gateway to the Great Barrier Reef - where whales, sharks and an abundance of marine life can be seen.
                    </span>
                </p>
                <button id="readMoreBtn">Read more <span>▼</span></button>
            </div>
        </div>
    </div>
</div>

<div class="expert-opinion">
    <div class="expert-wrapper">
        <div class="profile-section">
            <img src="<?php echo e(asset('assets/front/images/Australia-exp.webp')); ?>" alt="Profile Image" class="profile-image">
            <h3> Cassie Stickland </h3>
            <p>Product Manager</p>
        </div>
        <div class="content-section">
            <h2>What our experts love about Australia</h2>
            <p>
                Sydney never fails to amaze me each time I visit. We've all seen photographs of Sydney Opera House but nothing compares to the moment you see it in real life. I love sitting at one of the outdoor tables at the Opera Bar with the sun on my face and a glass of wine in hand, enjoying the view out across to Sydney Harbour Bridge.
            </p>
        </div>
    </div>
</div>


<div class="best-places">
    <div class="best-places-container">
        <h3>What are the best places to visit in Australia?</h3>
        <p>It’s a huge country, and there are countless incredible sights to see and cities to explore. We’ve highlighted a few icons below, which we include on all of our Australia touring holidays.</p>


        <div class="placeBox">
            <div class="boxText">
                <h4>Sydney</h4>
                <p>The Opera House, the Harbour Bridge, Bondi Beach – you’ve seen them countless times on screen, but nothing’s quite like the real thing. You’re never too far from the water here, whether you’re surfing in Manly, walking the cliff paths at Tamarama or skirting the harbour’s edge on a sightseeing cruise. Don’t miss the historic Rocks district, where you’ll get a glimpse into Sydney’s fascinating past. If you fancy a day trip, the beautiful Blue Mountains region is just a couple of hours away.</p>

                <!-- <button class="explore-button">
                        Explore more <span><img src="<?php echo e(asset('assets/front/images/right.png')); ?>" alt=""></span>
                    </button> -->
            </div>
            <div class="imgBox">
                <img src="<?php echo e(asset('assets/front/images/sydney.jpg')); ?>" alt="">
            </div>
        </div>

        <div class="placeBox">
            <div class="imgBox">
                <img src="<?php echo e(asset('assets/front/images/rockey.jpg')); ?>" alt="">
            </div>
            <div class="boxText">
                <h4>Great Barrier Reef</h4>
                <p>Where else in the world can you experience a rich ecosystem that spans some 2,000km of coastline? Rated as one of seven Natural Wonders of the World, the remarkable Great Barrier Reef is visible from space - but you don’t have to travel out of this world to enjoy it. To see the incredible and diverse marine life on our Australia tours, hop on board a semi-submersible boat and experience an underwater observatory, snorkel in the crystal-clear coral waters or even dive below the waves. The multitude of colourful tropical fish will astound, as will the diverse marine life - think turtles, clown fish and sharks.</p>

                <!-- <button class="explore-button">
                        Explore more <span><img src="<?php echo e(asset('assets/front/images/right.png')); ?>" alt=""></span>
                    </button> -->
            </div>

        </div>

        <div class="placeBox">
            <div class="boxText">
                <h4>Uluru</h4>
                <p>This giant sandstone monolith stands in Australia’s barren ‘Red Centre’. At more than 1,100 feet high, it towers over its surroundings – acres of empty Outback. Get up close and personal with a walk around the base. You’ll see hidden caves and Aboriginal rock art, and a few tree-shaded water holes. Uluru’s ever-changing colours are at their most spectacular at sunset. As the sun starts to dip below the horizon, the rock turns from burnt orange to a deep crimson, and the sky fills with stars.</p>

                <!-- <button class="explore-button">
                        Explore more <span><img src="<?php echo e(asset('assets/front/images/right.png')); ?>" alt=""></span>
                    </button> -->
            </div>
            <div class="imgBox">
                <img src="<?php echo e(asset('assets/front/images/uluruu.jpg')); ?>" alt="">
            </div>
        </div>

    </div>

</div>


<div class="recommendation-box">
    <h3>Recommended Australia holidays</h3>
    <div class="re-wrapper">
        <div class="travel-card">
            <div class="card-image">
                <img src="<?php echo e(asset('assets/front/images/aus_1.webp')); ?>" alt="Southern Sights and Sounds" />
            </div>
            <div class="travContent">
                <div class="card-content">
                    <h2>The Best of Australia and New Zealand</h2>
                    <p class="location"><span>&#x1F4CD;</span> New Zealand</p>
                    <ul>
                        <li>● 36 nights in hotels and 3 in flight</li>
                        <li>● 44 meals included</li>
                        <li>● 33 excursions & visits</li>
                        <li>● Titan's VIP door-to-door travel service</li>
                    </ul>
                </div>
                <div>
                    <p class="duration-price">
                        <span class="duration">40 days</span> from <span class="price">£9,346pp</span>
                    </p>
                    <button class="holiday-button">
                        Holiday details <span>&#8594;</span>
                    </button>
                </div>
            </div>
        </div>
        <div class="travel-card">
            <div class="card-image">
                <img src="<?php echo e(asset('assets/front/images/aus_2.jpeg')); ?>" alt="Southern Sights and Sounds" />
            </div>
            <div class="travContent">
                <div class="card-content">
                    <h2>The Best of Australia</h2>
                    <p class="location"><span>&#x1F4CD;</span> Australia</p>
                    <ul>
                        <li>● 19 nights in hotels and 3 in flight</li>
                        <li>● 21 meals included</li>
                        <li>● 17 excursions & visits</li>
                        <li>● Titan's VIP door-to-door travel service</li>
                    </ul>
                </div>
                <div>
                    <p class="duration-price">
                        <span class="duration">23 days</span> from <span class="price">£5,946pp</span>
                    </p>
                    <button class="holiday-button">
                        Holiday details <span>&#8594;</span>
                    </button>
                </div>
            </div>
        </div>
        <div class="travel-card">
            <div class="card-image">
                <img src="<?php echo e(asset('assets/front/images/aus_3.jpeg')); ?>" alt="Southern Sights and Sounds" />
            </div>
            <div class="travContent">
                <div class="card-content">
                    <h2>Grand Tour of Australia</h2>
                    <p class="location"><span>&#x1F4CD;</span> Australia</p>
                    <ul>
                        <li>● 27 nights in hotels and 2 in flight</li>
                        <li>● 31 meals included</li>
                        <li>● 21 excursions & visits</li>
                        <li>● Titan's VIP door-to-door travel service</li>
                    </ul>
                </div>
                <div>
                    <p class="duration-price">
                        <span class="duration">30 days</span> from <span class="price">£7,467pp</span>
                    </p>
                    <button class="holiday-button">
                        Holiday details <span>&#8594;</span>
                    </button>
                </div>
            </div>
        </div>

    </div>
</div>

<div class="video">
    <h3>Find out more</h3>
    <div class="video-container">
        <iframe
            width="560"
            height="315"
            src="https://www.youtube.com/embed/BslCJOuAx8I?si=nmlUa4JybrB94gFM"
            title="YouTube video player"
            frameborder="0"
            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
            allowfullscreen></iframe>

    </div>


</div>

<div class="faq">
    <h3>More information about Australia</h3>
    <div class="faqwrapper">
        <button class="accordion">Why should you holiday in Australia with Titan?<img class="faqArrow" src="<?php echo e(asset('assets/front/images/downArrow.png')); ?>" alt=""></button>
        <div class="panel">
            <p>Each of our Australia holidays includes our VIP door-to-door travel service to take you to your chosen UK airport, plus an expert tour manager on hand to keep everything running smoothly while you’re away.</p>
            <br>
            <p>Although many excursions are included in the price already, our selection of optional excursions can help you get even more out of your holiday, whether it’s a whale-watching tour or a side-trip to Niagara Falls.</p>
        </div>
        <button class="accordion">When is the best time to visit Australia? <img class="faqArrow" src="<?php echo e(asset('assets/front/images/downArrow.png')); ?>" alt=""></button>
        <div class="panel">
            <p>Our Australia escorted tours depart across spring, summer and autumn, avoiding the cold weather and often heavy snowfall that much of the country experiences during winter. The summer months are great for whale watching on both coasts and wildlife spotting in the Rockies, while spring and autumn tend to be cooler but much less crowded in the most popular destinations.</p>
        </div>
        <button class="accordion">What are the hotel options on your Canadian tours?<img class="faqArrow" src="<?php echo e(asset('assets/front/images/downArrow.png')); ?>" alt=""></button>
        <div class="panel">
            <p>The hotels we feature have all been hand-selected by our team to give you the best possible experience. If you take a look at the itineraries for each of our Australia tour packages, you’ll see the hotel names listed for each night of the tour.
                &nbsp;&nbsp;</p>
        </div>

        <button class="accordion">What is the food and drink like in Australia?<img class="faqArrow" src="<?php echo e(asset('assets/front/images/downArrow.png')); ?>" alt=""></button>
        <div class="panel">
            <p><span>There's a huge variety of different dishes and flavours to try, from French cuisine in Quebec to seafood in Nova Scotia to Asian fusion on the west coast.</span></p> <br>
            <p><span>Must-try dishes include poutine (chips topped with gravy and cheese curds - Canadian fast food at its finest); pancakes served with bacon and drizzled with maple syrup; sweet, flaky butter tarts; and freshly caught salmon.</span></p> <br>

            <p><span>Wines are primarily produced in Ontario and British Columbia and are well worth trying. Look out for ice wine, too, made from grapes which have frozen on the vine during Australia's cold winter months.</span></p>
        </div>
        <button class="accordion">Do you need a visa for Australia?<img class="faqArrow" src="<?php echo e(asset('assets/front/images/downArrow.png')); ?>" alt=""></button>
        <div class="panel">
            <p><span>Visa requirements for Australia holidays vary depending on the passport you hold and the length of time you’re planning on staying. For the most up-to-date information on visas, please use the quick-check tool on our visa requirements page.</a><span>.&nbsp;</span></p>
        </div>
    </div>

</div>

<div class="otherDestination">
    <h3>Other popular <br> destinations</h3>
    <div class="destinationContainer">
        <div class="destBoxes">
            <div class="BoxImg"><img src="<?php echo e(asset('assets/front/images/desti1.webp')); ?>" alt=""></div>
            <h4>Alaska</h4>
        </div>
        <div class="destBoxes">
            <div class="BoxImg"><img src="<?php echo e(asset('assets/front/images/desti2.webp')); ?>" alt=""></div>
            <h4>Australia</h4>
        </div>
        <div class="destBoxes">
            <div class="BoxImg"><img src="<?php echo e(asset('assets/front/images/desti3.webp')); ?>" alt=""></div>
            <h4>Australia</h4>
        </div>
        <div class="destBoxes">
            <div class="BoxImg"><img src="<?php echo e(asset('assets/front/images/desti4.webp')); ?>" alt=""></div>
            <h4>Mexico</h4>
        </div>
        <div class="destBoxes">
            <div class="BoxImg"><img src="<?php echo e(asset('assets/front/images/desti5.webp')); ?>" alt=""></div>
            <h4>New Zealand</h4>
        </div>
        <div class="destBoxes">
            <div class="BoxImg"><img src="<?php echo e(asset('assets/front/images/desti6.webp')); ?>" alt=""></div>
            <h4>South Africa</h4>
        </div>

    </div>
</div>

<div class="blogSection">
    <h3>Read more about Australia on our blog</h3>
    <div class="blog-container">
        <div class="blog-card">
            <img src="<?php echo e(asset('assets/front/images/blog1.webp')); ?>" alt="Route 66 Road" class="blog-image" />
            <div class="blog-content">
                <p class="blog-category">BLOG</p>
                <h3 class="blog-title">Australia: What...</h3>
                <p class="blog-time">3 min read</p>
            </div>
        </div>
        <div class="blog-card">
            <img src="<?php echo e(asset('assets/front/images/blog2.webp')); ?>" alt="Route 66 Road" class="blog-image" />
            <div class="blog-content">
                <p class="blog-category">BLOG</p>
                <h3 class="blog-title">4 fabulous reasons...</h3>
                <p class="blog-time">3 min read</p>
            </div>
        </div>
        <div class="blog-card">
            <img src="<?php echo e(asset('assets/front/images/blog3.webp')); ?>" alt="Route 66 Road" class="blog-image" />
            <div class="blog-content">
                <p class="blog-category">BLOG</p>
                <h3 class="blog-title">Cruise & Tour...</h3>
                <p class="blog-time">3 min read</p>
            </div>
        </div>

    </div>
</div>

<div class="userDet">
    <div class="userInput">
        <div class="newsletter-section">
            <h3>Receive inspiration in your inbox</h3>
            <p>Subscribe to our newsletter for holiday inspiration and the latest special offers</p>

            <form class="newsletter-form">
                <div class="input-det-wrapper">
                    <div class="input-group">
                        <div class="input-container">
                            <label for="first-name">First name</label>
                            <input type="text" id="first-name" name="first-name">
                        </div>
                        <div class="input-container">
                            <label for="last-name">Last name</label>
                            <input type="text" id="last-name" name="last-name">
                        </div>
                    </div>

                    <div class="input-container full-width">
                        <label for="email">Email</label>
                        <input type="email" id="email" name="email">
                    </div>
                </div>

                <button type="submit" class="submit-button">Submit</button>
            </form>

            <p class="privacy-text">For more information about how we use your personal information, please view our <a href="#">Privacy Policy</a>.</p>
        </div>

    </div>
</div>

<div class="whyChooseUs">
    <div class="usContainer">
        <h3>Why choose a Titan tour?</h3>
        <p>Titan Travel have always been about seeing more and doing more – which is why we meticulously plan our award-winning escorted tours so that our expertly crafted itineraries make sure that so much is included. Once you book your holiday, you can relax knowing that every element has been taken care of. Choose the tour that gives you more.</p>

        <div class="highlights">
            <div class="highlightBox">
                <img src="<?php echo e(asset('assets/front/svg/bus.svg')); ?>" alt="">
                <h4>VIP travel Services</h4>
                <p>Smooth transfers to and from home with unlimited mileage</p>
            </div>
            <div class="highlightBox">
                <img src="<?php echo e(asset('assets/front/svg/star.svg')); ?>" alt="">
                <h4>More value</h4>
                <p>From excursions to hotels, entry tickets and dining packages, we include more than any other tour.</p>
            </div>
            <div class="highlightBox">
                <img src="<?php echo e(asset('assets/front/svg/user.svg')); ?>" alt="">
                <h4>More knowledgeable</h4>
                <p>Be guided by some of the most passionate and knowledgeable tour managers in the world, on hand to help every step of the way.</p>
            </div>
            <div class="highlightBox">
                <img src="<?php echo e(asset('assets/front/svg/plus.svg')); ?>" alt="">
                <h4>More flexible</h4>
                <p>Feel free to amend or extend your travel plans, up until final payment, and enjoy free time on your tour with us too.</p>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('javascript'); ?>
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

<script src="<?php echo e(asset('assets/front/js/usascript.js')); ?>"></script>
<script>
    var swiper = new Swiper(".mySwiper", {
        slidesPerView: 'auto',
        spaceBetween: -20,
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\journey\resources\views/front/australia.blade.php ENDPATH**/ ?>