<?php
$users = \Auth::user();
$currantLang = $users->currentLanguage();
$languages = Utility::languages();


// $profile = asset(Storage::url('uploads/avatar/'));
?>
<div class="main-sidebar">
    <aside id="sidebar-wrapper">
        <div class="sidebar-brand">
            
            <?php if(\Auth::user()->type == 'Partner'): ?>
            <img src="<?php echo e(asset('assets/img/logo/logo.svg')); ?>" class="app-logo " width="50px">

            <?php else: ?>
            <img src="<?php echo e(Storage::url('logo/app-logo.png')); ?>" class="app-logo " width="50px">

            <?php endif; ?>

        </div>
        <div class="sidebar-brand sidebar-brand-sm">
            <img src="<?php echo e(Storage::url('logo/app-small-logo.png')); ?>" class="app-logo " width="50px">

            

            <img src="" class="app-logo w-50">

        </div>
        <ul class="sidebar-menu pt-3">

            <li>
                <a class="nav-link" href="<?php echo e(route('home')); ?>"><i class="fas fa-fire text-primary"></i>
                    <span><?php echo e(__('Dashboard')); ?></span></a>
            </li>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-user')): ?>

            <li>
                <a class="nav-link" href="<?php echo e(route('manage-users')); ?>"><i class="fas fa-users text-primary"></i>
                    <span><?php echo e(__('Users')); ?></span></a>
            </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-partner')): ?>

            <li>
                <a class="nav-link" href="<?php echo e(route('users.index')); ?>"><i class="fas fa-users text-primary"></i>
                    <span><?php echo e(__('Partners')); ?></span></a>
            </li>

            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-transaction')): ?>
            <li>
                <a class="nav-link" href="<?php echo e(route('transactions')); ?>"><i class="fas fa-money-bill text-primary"></i>
                    <span><?php echo e(__('Transaction')); ?></span></a>
            </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-game')): ?>
            <li>
                <a class="nav-link" href="<?php echo e(route('games.index')); ?>"><i class="fas fa-gamepad text-primary"></i>
                    <span><?php echo e(__('Games')); ?></span></a>
            </li>
            <li>
                <a class="nav-link" href="<?php echo e(route('meetings.index')); ?>"><i class="fas fa-gamepad text-primary"></i>
                    <span><?php echo e(__('Webex Meeting')); ?></span></a>
            </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-withdraw')): ?>
            <li>
                <a class="nav-link  " href="<?php echo e(route('withdraw-request-list')); ?>"><i class="fas fa-money-bill text-primary"></i>
                    <span>Withdraw Requests</span>
                </a>
            </li>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-setting')): ?>
            <li>
                <a class="nav-link" href="<?php echo e(route('settings')); ?>"><i class="fas fa-pencil-ruler text-primary  "></i>
                    <span><?php echo e(__('Settings')); ?></span></a>
            </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-language')): ?>
            <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('manage.language', [$currantLang])); ?>">
                    <i class="fas fa-globe text-primary"></i>
                    <span class="nav-link-text"><?php echo e(__('Manage Language')); ?></span>
                </a>
            </li>
            <?php endif; ?>


        </ul>


    </aside>
</div><?php /**PATH C:\laragon\www\bluechip\resources\views/admin/menu.blade.php ENDPATH**/ ?>