@extends('layouts.admin')
@section('title')
{{ __('withdraws') }}
@endsection

@section('content')
<div class="page-content-wrapper">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="page-title-box">



                    <h4 class="page-title mt-2">withdraw List</h4>

                </div>
            </div>
        </div>



        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="mt-0 d-none header-title">Conditional search</h4>
                        <div class="row d-none">
                            <div class="col-6 mb-3">
                                <h6 class="input-title mt-2">Enter User Name</h6>
                                <input type="text" class="form-control" maxlength="25" name="username" id="search_username" placeholder="Enter user name" />
                            </div>
                            <div class="col-6 mb-3">
                                <h6 class="input-title mt-2">Enter Phone Number</h6>
                                <input type="text" class="form-control" maxlength="25" name="mobile_number" id="search_mobile_number" placeholder="Enter phone number" />
                            </div>
                            <div class="col-6 mb-3">
                                <h6 class="input-title mt-2">Select Registration Date</h6>
                                <input type="date" class="form-control" maxlength="25" name="r_date" id="search_r_date" />
                            </div>
                            <div class="col-6 mt-3">
                                <div class="btn-group float-right">

                                    <button type="button" id="filter" class="btn btn-primary waves-effect mb-3">Search Data</button>

                                </div>
                            </div>

                        </div>
                        <div class="table-responsive py-4">
                            {{ $dataTable->table(['width' => '100%']) }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



@endsection

@push('css')
<link rel="stylesheet" href="{{ asset('assets/admin/lib/datatables/dataTables.css') }}">
@include('layouts.includes.datatable_css')
@endpush
@push('javascript')
<!-- <script src="{{ asset('assets/admin/lib/jquery/jquery-3.7.1.min.js') }}"></script> -->
<!-- <script src="{{ asset('assets/admin/lib/datatables/dataTables.js') }}"></script> -->
@include('layouts.includes.datatable_js')

<script>
    $(document).ready(function() {
        $(document).on("change", ".change_status", function() {
            var url = $(this).val();
            window.location.href = url
        });

        window.LaravelDataTables = null;



        function getData() {
            if (window.LaravelDataTables == null) {
                window.LaravelDataTables = $("#forms-table").DataTable({
                    "serverSide": true,
                    "processing": true,
                    "ajax": {
                        "url": "{{ route('withdraw_list') }}",
                        "type": "GET",
                        "data": function(data) {
                            for (var i = 0, len = data.columns.length; i < len; i++) {
                                if (!data.columns[i].search.value) delete data.columns[i].search;
                                if (data.columns[i].searchable === true) delete data.columns[i].searchable;
                                if (data.columns[i].orderable === true) delete data.columns[i].orderable;
                                if (data.columns[i].data === data.columns[i].name) delete data.columns[i].name;
                            }
                            delete data.search.regex;
                            data.user_id = '{{$user_id}}';
                        }
                    },
                    "columns": [{
                        "data": "id",
                        "name": "id",
                        "title": "Id",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "username",
                        "name": "username",
                        "title": "Username",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "amount",
                        "name": "amount",
                        "title": "Amount",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "actual_arrival",
                        "name": "actual_arrival",
                        "title": "Actual Arrival",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "chain_type",
                        "name": "chain_type",
                        "title": "Chain Type",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "bank_card_number",
                        "name": "bank_card_number",
                        "title": "Bank Card Number",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "contact_number",
                        "name": "contact_number",
                        "title": "Contact Number",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "created_at",
                        "name": "created_at",
                        "title": "Created At",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "status",
                        "name": "status",
                        "title": "Status",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "action",
                        "name": "action",
                        "title": "Action",
                        "orderable": false,
                        "searchable": false,
                        "width": 200,
                        "className": "text-center"
                    }],
                    "order": [
                        [1, "desc"]
                    ],
                    "language": {
                        "paginate": {
                            "next": "<i class=\"fas fa-angle-right\"><\/i>",
                            "previous": "<i class=\"fas fa-angle-left\"><\/i>"
                        }
                    },
                    "scrollX": true
                });
            } else {
                window.LaravelDataTables.ajax.reload();
            }
        }
        getData();

    });
</script>
@endpush