@extends('layouts.admin')
@section('title')
{{ __('Members') }}
@endsection

@section('content')
<div class="page-content-wrapper">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="page-title-box">
                    <div class="btn-group float-right">

                        <button type="button" class="btn btn-secondary waves-effect mb-3" data-toggle="modal" data-target="#exampleModal05">Add Member</button>

                    </div>

                    <div class="modal fade" id="exampleModal05" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <form method="POST" action="{{ route('users.store') }}">
                                    @csrf
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel">Add Member</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">

                                        <h6 class="input-title mt-2"> User Name</h6>
                                        <input type="text" class="form-control" maxlength="25" name="username" id="username" placeholder="Enter user name" />

                                        <h6 class="input-title mt-2">Phone Number</h6>
                                        <input type="text" class="form-control" maxlength="25" name="mobile_number" id="mobile_number" placeholder="Enter Phone Number" />

                                        <h6 class="input-title mt-2">Login Password</h6>
                                        <input type="password" class="form-control" maxlength="25" name="password" id="password" placeholder="Enter Login Password" />

                                        <h6 class="input-title mt-2">Transcation Password</h6>
                                        <input type="number" class="form-control" maxlength="25" name="redemption_pin" id="redemption_pin" placeholder="Enter Transcation Password" />

                                        <h6 class="input-title mt-2">Select Referral</h6>
                                        <select name="referral_by" class="form-control custom_select" style="width: 100%;">
                                            <option value="">Select User</option>
                                            @foreach($users as $user)
                                            <option value="{{ $user->id }}">{{ $user->id }} - {{$user->username}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="modal-footer">
                                        <input type="hidden" value="User" name="type">
                                        <button type="submit" class="btn btn-secondary">Submit</button>
                                        <button type="button" class="btn btn-primary">Cancel</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <h4 class="page-title mt-2">Members List</h4>

                </div>
            </div>
        </div>



        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="mt-0 header-title">Conditional search</h4>
                        <div class="row">
                            <div class="col-6 mb-3">
                                <h6 class="input-title mt-2">Enter User Name</h6>
                                <input type="text" class="form-control" maxlength="25" name="username" id="search_username" placeholder="Enter user name" />
                            </div>
                            <div class="col-6 mb-3">
                                <h6 class="input-title mt-2">Enter Phone Number</h6>
                                <input type="text" class="form-control" maxlength="25" name="mobile_number" id="search_mobile_number" placeholder="Enter phone number" />
                            </div>
                            <div class="col-6 mb-3">
                                <h6 class="input-title mt-2">Select Registration Date</h6>
                                <input type="date" class="form-control" maxlength="25" name="r_date" id="search_r_date" />
                            </div>
                            <div class="col-6 mt-3">
                                <div class="btn-group float-right">

                                    <button type="button" id="filter" class="btn btn-primary waves-effect mb-3">Search Data</button>

                                </div>
                            </div>
                            <div class="col-6 d-none">
                                <h6 class="input-title mt-2">Single select</h6>
                                <select class="select2 form-control mb-3 custom-select" style="width: 100%; height: 36px;">
                                    <option>Select</option>
                                    <optgroup label="Alaskan/Hawaiian Time Zone">
                                        <option value="AK">Alaska</option>
                                        <option value="HI">Hawaii</option>
                                    </optgroup>
                                    <optgroup label="Pacific Time Zone">
                                        <option value="CA">California</option>
                                        <option value="NV">Nevada</option>
                                        <option value="OR">Oregon</option>
                                        <option value="WA">Washington</option>
                                    </optgroup>
                                    <optgroup label="Mountain Time Zone">
                                        <option value="AZ">Arizona</option>
                                        <option value="CO">Colorado</option>
                                        <option value="ID">Idaho</option>
                                        <option value="MT">Montana</option>
                                        <option value="NE">Nebraska</option>
                                        <option value="NM">New Mexico</option>
                                        <option value="ND">North Dakota</option>
                                        <option value="UT">Utah</option>
                                        <option value="WY">Wyoming</option>
                                    </optgroup>
                                    <optgroup label="Central Time Zone">
                                        <option value="AL">Alabama</option>
                                        <option value="AR">Arkansas</option>
                                        <option value="IL">Illinois</option>
                                        <option value="IA">Iowa</option>
                                        <option value="KS">Kansas</option>
                                        <option value="KY">Kentucky</option>
                                        <option value="LA">Louisiana</option>
                                        <option value="MN">Minnesota</option>
                                        <option value="MS">Mississippi</option>
                                        <option value="MO">Missouri</option>
                                        <option value="OK">Oklahoma</option>
                                        <option value="SD">South Dakota</option>
                                        <option value="TX">Texas</option>
                                        <option value="TN">Tennessee</option>
                                        <option value="WI">Wisconsin</option>
                                    </optgroup>
                                    <optgroup label="Eastern Time Zone">
                                        <option value="CT">Connecticut</option>
                                        <option value="DE">Delaware</option>
                                        <option value="FL">Florida</option>
                                        <option value="GA">Georgia</option>
                                        <option value="IN">Indiana</option>
                                        <option value="ME">Maine</option>
                                        <option value="MD">Maryland</option>
                                        <option value="MA">Massachusetts</option>
                                        <option value="MI">Michigan</option>
                                        <option value="NH">New Hampshire</option>
                                        <option value="NJ">New Jersey</option>
                                        <option value="NY">New York</option>
                                        <option value="NC">North Carolina</option>
                                        <option value="OH">Ohio</option>
                                        <option value="PA">Pennsylvania</option>
                                        <option value="RI">Rhode Island</option>
                                        <option value="SC">South Carolina</option>
                                        <option value="VT">Vermont</option>
                                        <option value="VA">Virginia</option>
                                        <option value="WV">West Virginia</option>
                                    </optgroup>
                                </select>
                            </div>
                        </div>
                        <div class="table-responsive py-4">
                            {{ $dataTable->table(['width' => '100%']) }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="exampleModal02" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="{{ route('incress-decress-amount') }}">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Plus Deduction</h5>

                </div>
                <div class="modal-body">
                    <h6 class="input-title mt-2"> User Name</h6>
                    <input type="text" readonly="readonly" class="form-control" maxlength="25" name="username" id="user_name" placeholder="Enter user name" />


                    <h6 class="input-title mt-2">Increase</h6>


                    <select name="type" class="form-control">
                        <option value="">Select</option>
                        <option value="credit">Increase</option>
                        <option value="debit">Deduct</option>
                    </select>

                    <h6 class="input-title mt-2"> Amount</h6>
                    <input type="number" class="form-control" maxlength="25" name="amount" id="amount" placeholder="Enter Amount" />


                </div>
                <div class="modal-footer">
                    <input type="hidden" name="user_id" id="user_id" value="0">
                    <button type="submit" class="btn btn-primary">Submit</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>

                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('css')
<link rel="stylesheet" href="{{ asset('assets/admin/lib/datatables/dataTables.css') }}">
@include('layouts.includes.datatable_css')
@endpush
@push('javascript')
<!-- <script src="{{ asset('assets/admin/lib/jquery/jquery-3.7.1.min.js') }}"></script> -->
<!-- <script src="{{ asset('assets/admin/lib/datatables/dataTables.js') }}"></script> -->
@include('layouts.includes.datatable_js')
<script>
    $(document).ready(function() {
        $('.custom_select').select2();
        $(document).on("click", "#filter", function() {
            getData();
        });

        $(document).on("click", ".incress-decress", function() {
            var id = $(this).data('id');
            var username = $(this).data('username');
            $('#user_name').val(username);
            $('#user_id').val(id);
            $('#exampleModal02').modal('show');
        });


        window.LaravelDataTables = null;

        function getData() {
            if (window.LaravelDataTables == null) {
                window.LaravelDataTables = $("#users-table").DataTable({
                    "serverSide": true,
                    "processing": true,
                    "ajax": {
                        "url": "{{ route('users.index') }}",
                        "type": "GET",
                        "data": function(data) {
                            for (var i = 0, len = data.columns.length; i < len; i++) {
                                if (!data.columns[i].search.value) delete data.columns[i].search;
                                if (data.columns[i].searchable === true) delete data.columns[i]
                                    .searchable;
                                if (data.columns[i].orderable === true) delete data.columns[i]
                                    .orderable;
                                if (data.columns[i].data === data.columns[i].name) delete data
                                    .columns[i]
                                    .name;
                            }
                            delete data.search.regex;
                            data.username = $("#search_username").val();
                            data.mobile_number = $("#search_mobile_number").val();
                            data.r_date = $("#search_r_date").val();
                        }
                    },
                    "columns": [{
                        "data": "id",
                        "name": "id",
                        "title": "Id",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "username",
                        "name": "username",
                        "title": "Username",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "balance",
                        "name": "balance",
                        "title": "Balance",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "visited_journey",
                        "name": "visited_journey",
                        "title": "Journey",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "number_of_journey",
                        "name": "number_of_journey",
                        "title": "Maximum Journey",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "level",
                        "name": "level",
                        "title": "Level",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "total_commission",
                        "name": "total_commission",
                        "title": "Commission",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "referral_by",
                        "name": "referral_by",
                        "title": "Referral By",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "mobile_number",
                        "name": "mobile_number",
                        "title": "Mobile number",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "referral_code",
                        "name": "referral_code",
                        "title": "Referral Code",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "last_login",
                        "name": "last_login",
                        "title": "Last Login At",
                        "orderable": true,
                        "searchable": true,
                        
                    }, {
                        "data": "action",
                        "name": "action",
                        "title": "Action",
                        "orderable": false,
                        "searchable": false,
                        "width": 120,
                        "className": "text-center"
                    }],
                    "language": {
                        "paginate": {
                            "next": "<i class=\"fas fa-angle-right\"><\/i>",
                            "previous": "<i class=\"fas fa-angle-left\"><\/i>"
                        }
                    },
                    "scrollX": true
                });
            } else {
                window.LaravelDataTables.ajax.reload();
            }
        }
        getData();

    });
</script>
@endpush