@extends('layouts.admin')
@section('title', $t)

@section('content')
<div class="page-content-wrapper">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="page-title-box">

                    <h4>{{ $t }}</h4>

                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="row">
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-header">
                                <h4>{{ __('Jump To') }}</h4>
                            </div>
                            <div class="card-body">
                                <ul class="nav nav-pills flex-column">
                                    <li class="nav-item"><a href="{{ route('setting', 'app-setting') }}"
                                            class="nav-link active">{{ __('App Setting') }}</a></li>
                                    <li class="nav-item"><a href="{{ route('setting', 'general-setting') }}"
                                            class="nav-link">{{ __('General') }}</a></li>
                                    <li class="nav-item"><a href="{{ route('setting', 'level-setting') }}"
                                            class="nav-link">{{ __('Level') }}</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-8">
                        <form id="setting-form" action="{{ route('settings/app-name/update') }}"
                            enctype="multipart/form-data" method="POST">
                            @csrf
                            <div class="card" id="settings-card">
                                <div class="card-header">
                                    <h4> {{ $t }}</h4>
                                </div>
                                <div class="card-body">
                                    <p class="text-muted"> {{ __('App Name') }} {{ __('& App Logo') }}</p>
                                    <div class="">
                                        <div class=" row">
                                            <div class="col-lg-12">
                                                <div class="form-group">
                                                    <label for="name">{{ __('App application name') }} </label>
                                                    <input type="text" name="app_name" class="form-control"
                                                        value="{{ Utility::getsettings('app_name') }}"
                                                        placeholder="{{ __('App application name') }}" required>
                                                </div>
                                            </div>
                                            <div class="col-lg-12">
                                                <div class="form-group bg-light text-center">
                                                    <img id="app-dark-logo"
                                                        class="img img-responsive my-3 w-50 justify-content-center text-center"
                                                        src="{{ Storage::url('logo/app-logo.png') }}" class="app-logo w-50"
                                                        alt="App_logo">

                                                </div>
                                                <div class="form-group">
                                                    <label for="name">{{ __('Select Logo') }}</label>
                                                    <input type="file" name="app_logo" class="form-control"
                                                        value="Select Logo">
                                                </div>
                                            </div>
                                            <div class="col-lg-12">
                                                <div class="form-group bg-light text-center">
                                                    <img id="app-dark-logo"
                                                        class="img img-responsive my-3 w-50 justify-content-center text-center"
                                                        src="{{ Storage::url('logo/app-small-logo.png') }}"
                                                        class="app-logo w-50" alt="app_small_logo">

                                                </div>
                                                <div class="form-group">
                                                    <label for="name">{{ __('Select small Logo') }}</label>
                                                    <input type="file" name="app_small_logo" class="form-control"
                                                        value="Select Small  Logo">
                                                </div>
                                            </div>
                                            <div class="col-lg-12">
                                                <div class="form-group bg-light text-center">
                                                    <img id="app-dark-logo"
                                                        class="img img-responsive my-3 w-50 justify-content-center text-center"
                                                        src="{{ Storage::url('logo/app-favicon-logo.png') }}"
                                                        {{-- src="{{ Utility::getpath('logo/app-favicon-logo.png') }}" --}} alt="favicon_logo">

                                                </div>
                                                <div class="form-group">
                                                    <label for="name">{{ __('Select favicon Logo') }}</label>
                                                    <input type="file" name="favicon_logo" class="form-control"
                                                        value="Select Favicon Logo">
                                                </div>
                                            </div>
                                            <div class="col-lg-12">
                                                <h5>Payment Setting (QR Code)</h5>
                                                <div class="form-group bg-light text-center">
                                                    <img id="app-dark-logo"
                                                        class="img img-responsive my-3 w-50 justify-content-center text-center"
                                                        src="{{ Storage::url('qrcode/app-qrcode.png') }}"
                                                        {{-- src="{{ Utility::getpath('logo/app-favicon-logo.png') }}" --}} alt="qrcode">

                                                </div>
                                                <div class="form-group">
                                                    <label for="name">{{ __('Select QR Code') }}</label>
                                                    <input type="file" name="qrcode" class="form-control"
                                                        value="Select QR Code">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer bg-whitesmoke text-md-right">
                                    <button class="btn btn-primary" type="submit"
                                        id="save-btn">{{ __('Save Changes') }}</button>
                                    <a href="{{ route('settings') }}" class="btn btn-secondary">{{ __('Cancel') }}</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection