@extends('layouts.admin')
@section('title')
{{ __('Meetings') }}
@endsection

@section('content')
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>Meetings</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="{{ route('home') }}">Dashboard</a></div>
                <div class="breadcrumb-item">Meetings</div>
            </div>
        </div>
        <div class="section-body">
            <div class="row ">
                <div class="col-12">
                    <div class="card p-3">
                        <iframe src="https://meet1346.webex.com/meet1346/j.php?MTID=m26303a9cc9ef4dedc89ebacc1a98b36d" width="800" height="600" frameborder="0"></iframe>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

@endsection

@push('css')
@include('layouts.includes.datatable_css')
@endpush
@push('javascript')
<script>
    $(document).ready(function() {
        // Wait for the iframe content to be loaded
        $('#webexFrame').on('load', function() {
            // Access the iframe content
            var webexIframe = $('#webexFrame').contents();

            // Hide the participant thumbnail element using jQuery
            webexIframe.find('.participant-thumbnail').hide();
        });
    });
</script>
@endpush