@php
$user = \Auth::user();
@endphp
@extends('layouts.main')
@push('css')
<link rel="stylesheet" href="{{ asset('assets/front/css/usa.css') }}">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
<link rel="stylesheet" href="{{ asset('assets/front/css/swiper.css') }}">

@endpush

@section('content')
<div class="content-wrapper">
    <!-- <div class="breadcrum">
        <a href="">
            <h3>Home /</h3>
        </a>
        <a href="">
            <h3>Destinations /</h3>
        </a>
        <a href="">
            <h3>New Zealand</h3>
        </a>
    </div> -->

    <div class="banner">
        <h1>incredible <span>New Zealand</span> tours</h1>
        <img src="{{ asset('assets/front/images/new-zeland.jpeg') }}" alt="">
    </div>

    <div class="country-banner-slider">
        <div class="banner-text-cont">
            <div class="iamge-slider">
                <div class="swiper mySwiper">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide"><img src="{{ asset('assets/front/images/nz1.webp') }}" alt=""></div>
                        <div class="swiper-slide"><img src="{{ asset('assets/front/images/nz2.webp') }}" alt=""></div>
                        <div class="swiper-slide"><img src="{{ asset('assets/front/images/nz3.webp') }}" alt=""></div>
                        <div class="swiper-slide"><img src="{{ asset('assets/front/images/nz4.webp') }}" alt=""></div>
                        <div class="swiper-slide"><img src="{{ asset('assets/front/images/nz5.webp') }}" alt=""></div>
                    </div>
                </div>

            </div>

            <div class="text-content">
                <p id="text">
                    With epic mountain ranges, ancient forests, sweeping coastlines and monumental fiords, our New Zealand holidays and tours reveal some of the most spectacular scenery on the planet. Travelling between the North and South Islands, you'll experience differing landscapes, from tropical rainforests to alpine meadows, spouting geysers to volcanic plateaux, lush vineyards to gorgeous beaches.

                    <span id="ellipsis">...</span>
                    <span id="extraText" style="display: none;">
                        New Zealand tours aren't just about looks, though. There's also 800 years of Māori culture to learn about, wildlife to watch out for (whales in Kaikoura, seals in Akaroa, penguins on the Otago Peninsula, kiwi birds in Rotorua) and world-class wines to sample.

                        Holidays to New Zealand involve a fair bit of planning and organisation - luckily, we take care of all of that for you. Whether you have three weeks or four, we’ve carefully constructed our New Zealand tour itineraries to allow you to fill your time with the very best experiences that the 'Land of the Long White Cloud' has to offer. Flights, transfers, hotels, excursions - it's all taken care of, so you won't need to worry about a thing. Just choose the tour that tempts you the most - an extraordinary adventure awaits…
                    </span>
                </p>
                <button id="readMoreBtn">Read more <span>▼</span></button>
            </div>
        </div>
    </div>
</div>

<div class="expert-opinion">
    <div class="expert-wrapper">
        <div class="profile-section">
            <img src="{{ asset('assets/front/images/nzpr.webp') }}" alt="Profile Image" class="profile-image">
            <h3> Hercules Zeris </h3>
            <p>Product Manager</p>
        </div>
        <div class="content-section">
            <h2>What our experts love about New Zealand</h2>
            <p>
                The South Island of New Zealand is full of so many breathtaking sights, but perhaps none quite as striking as when you spot the snowy, rugged peak of Mount Cook piercing through the clouds for the first time. It took my breath away.


            </p>
        </div>
    </div>
</div>


<div class="best-places">
    <div class="best-places-container">
        <h3>What are the best places to visit in New Zealand</h3>
        <p>Although cities like Auckland, Wellington and Queenstown are packed with culture, quirky restaurants and some wonderful architecture, New Zealand is best known for its great outdoors. From the Bay of Islands in the North to Milford Sound in the south, you can expect big skies and cinematic landscapes that will impress, excite and inspire you in equal measure.</p>


        <div class="placeBox">
            <div class="boxText">
                <h4>North Island</h4>
                <p>Experience the almost otherworldly geothermal landscape of Rotorua, with its steaming geysers, bubbling mud pools and natural hot springs. Attending a traditional hangi feast here is an unforgettable highlight for many visitors. In Wellington you can learn about the country’s fascinating history in Te Papa national museum, stroll through the lovely Botanical Gardens, and raise a glass of local sauvignon blanc at one of the capital’s smart harbour-front restaurants. You can also relive the 1930s in Napier, a city famed for its colourful art deco architecture, and explore Auckland's museums, galleries, parks and gardens.</p>

                <!-- <button class="explore-button">
                        Explore more <span><img src="{{ asset('assets/front/images/right.png') }}" alt=""></span>
                    </button> -->
            </div>
            <div class="imgBox">
                <img src="{{ asset('assets/front/images/north.jpg') }}" alt="">
            </div>
        </div>

        <div class="placeBox">
            <div class="imgBox">
                <img src="{{ asset('assets/front/images/south.jpg') }}" alt="">
            </div>
            <div class="boxText">
                <h4>South Island</h4>
                <p>Marvel at the wonders of the Southern Alps - Mount Cook, New Zealand’s highest peak, and the breathtaking Fox and Franz Josef glaciers. Board a vintage steamship for a scenic cruise on Queenstown's beautiful Lake Wakatipu, surrounded by mountains crags and canyons. On South Island's east coast, spot the Scottish influence in Dunedin. It’s the gateway to the Otago Peninsula, a beautiful wildlife haven where you’ll find colonies of endangered, yellow-eyed penguins and albatrosses.</p>

                <!-- <button class="explore-button">
                        Explore more <span><img src="{{ asset('assets/front/images/right.png') }}" alt=""></span>
                    </button> -->
            </div>

        </div>




    </div>

</div>


<div class="recommendation-box">
    <h3>Recommended New Zealand holidays</h3>
    <div class="re-wrapper">
        <div class="travel-card">
            <div class="card-image">
                <img src="{{ asset('assets/front/images/nzh1.jpeg') }}" alt="Southern Sights and Sounds" />
            </div>
            <div class="travContent">
                <div class="card-content">
                    <h2>The Best of Australia and New Zealand</h2>
                    <p class="location"><span>&#x1F4CD;</span> New Zealand</p>
                    <ul>
                        <li>● 36 nights in hotels, 7 nights cruise on Koningsdam and 3 in flight</li>
                        <li>● 44 meals included</li>
                        <li>● 33 excursions & visits</li>
                        <li>● Titan's VIP door-to-door travel service</li>
                    </ul>
                </div>
                <div>
                    <p class="duration-price">
                        <span class="duration">40 days</span> from <span class="price">£9,346pp</span>
                    </p>
                    <button class="holiday-button">
                        Holiday details <span>&#8594;</span>
                    </button>
                </div>
            </div>
        </div>
        <div class="travel-card">
            <div class="card-image">
                <img src="{{ asset('assets/front/images/nzh2.jpeg') }}" alt="Southern Sights and Sounds" />
            </div>
            <div class="travContent">
                <div class="card-content">
                    <h2>The Best of New Zealand</h2>
                    <p class="location"><span>&#x1F4CD;</span> New Zealand </p>
                    <ul>
                        <li>● 17 nights in hotels and 3 in flight</li>
                        <li>● 23 meals included</li>
                        <li>● 16 excursions & visits</li>
                        <li>● Titan's VIP door-to-door travel service</li>
                    </ul>
                </div>
                <div>
                    <p class="duration-price">
                        <span class="duration">27 days</span> from <span class="price">£7,795pp</span>
                    </p>
                    <button class="holiday-button">
                        Holiday details <span>&#8594;</span>
                    </button>
                </div>
            </div>
        </div>
        <div class="travel-card">
            <div class="card-image">
                <img src="{{ asset('assets/front/images/nzh3.jpeg') }}" alt="Southern Sights and Sounds" />
            </div>
            <div class="travContent">
                <div class="card-content">
                    <h2>Great New Zealand Discovery</h2>
                    <p class="location"><span>&#x1F4CD;</span> New Zealand </p>
                    <ul>
                        <li>● 23 nights in hotels and 3 in flight</li>
                        <li>● 28 meals included</li>
                        <li>● 18 excursions & visits</li>
                        <li>● Titan's VIP door-to-door travel service</li>
                    </ul>
                </div>
                <div>
                    <p class="duration-price">
                        <span class="duration">14 days</span> from <span class="price">£4,795pp</span>
                    </p>
                    <button class="holiday-button">
                        Holiday details <span>&#8594;</span>
                    </button>
                </div>
            </div>
        </div>

    </div>
</div>

<div class="video">
    <h3>Find out more</h3>
    <div class="video-container">
        <iframe
            width="560"
            height="315"
            src="https://www.youtube.com/embed/wtXDJQ0qmG0?si=-GdcJCNYVf4KM4u7"
            title="YouTube video player"
            frameborder="0"
            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
            allowfullscreen></iframe>

    </div>


</div>

<div class="faq">
    <h3>More information about New Zealand</h3>
    <div class="faqwrapper">
        <button class="accordion">Why should you holiday in New Zealand with Titan?<img class="faqArrow" src="{{ asset('assets/front/images/downArrow.png') }}" alt=""></button>
        <div class="panel">
            <p>Each of our New Zealand holidays includes our VIP door-to-door travel service to take you to your chosen UK airport, plus an expert tour manager on hand to keep everything running smoothly while you’re away.</p>
            <br>
            <p>Although many excursions are included in the price already, our selection of optional excursions can help you get even more out of your holiday, whether it’s a whale-watching tour or a side-trip to Niagara Falls.</p>
        </div>
        <button class="accordion">When is the best time to visit New Zealand? <img class="faqArrow" src="{{ asset('assets/front/images/downArrow.png') }}" alt=""></button>
        <div class="panel">
            <p>Our New Zealand escorted tours depart across spring, summer and autumn, avoiding the cold weather and often heavy snowfall that much of the country experiences during winter. The summer months are great for whale watching on both coasts and wildlife spotting in the Rockies, while spring and autumn tend to be cooler but much less crowded in the most popular destinations.</p>
        </div>
        <button class="accordion">What are the hotel options on your Canadian tours?<img class="faqArrow" src="{{ asset('assets/front/images/downArrow.png') }}" alt=""></button>
        <div class="panel">
            <p>The hotels we feature have all been hand-selected by our team to give you the best possible experience. If you take a look at the itineraries for each of our New Zealand tour packages, you’ll see the hotel names listed for each night of the tour.
                &nbsp;&nbsp;</p>
        </div>

        <button class="accordion">What is the food and drink like in New Zealand?<img class="faqArrow" src="{{ asset('assets/front/images/downArrow.png') }}" alt=""></button>
        <div class="panel">
            <p><span>There's a huge variety of different dishes and flavours to try, from French cuisine in Quebec to seafood in Nova Scotia to Asian fusion on the west coast.</span></p> <br>
            <p><span>Must-try dishes include poutine (chips topped with gravy and cheese curds - Canadian fast food at its finest); pancakes served with bacon and drizzled with maple syrup; sweet, flaky butter tarts; and freshly caught salmon.</span></p> <br>

            <p><span>Wines are primarily produced in Ontario and British Columbia and are well worth trying. Look out for ice wine, too, made from grapes which have frozen on the vine during New Zealand's cold winter months.</span></p>
        </div>
        <button class="accordion">Do you need a visa for New Zealand?<img class="faqArrow" src="{{ asset('assets/front/images/downArrow.png') }}" alt=""></button>
        <div class="panel">
            <p><span>Visa requirements for New Zealand holidays vary depending on the passport you hold and the length of time you’re planning on staying. For the most up-to-date information on visas, please use the quick-check tool on our visa requirements page.</a><span>.&nbsp;</span></p>
        </div>
    </div>

</div>

<div class="otherDestination">
    <h3>Other popular <br> destinations</h3>
    <div class="destinationContainer">
        <div class="destBoxes">
            <div class="BoxImg"><img src="{{ asset('assets/front/images/desti1.webp') }}" alt=""></div>
            <h4>Alaska</h4>
        </div>
        <div class="destBoxes">
            <div class="BoxImg"><img src="{{ asset('assets/front/images/desti2.webp') }}" alt=""></div>
            <h4>Australia</h4>
        </div>
        <div class="destBoxes">
            <div class="BoxImg"><img src="{{ asset('assets/front/images/desti3.webp') }}" alt=""></div>
            <h4>New Zealand</h4>
        </div>
        <div class="destBoxes">
            <div class="BoxImg"><img src="{{ asset('assets/front/images/desti4.webp') }}" alt=""></div>
            <h4>Mexico</h4>
        </div>
        <div class="destBoxes">
            <div class="BoxImg"><img src="{{ asset('assets/front/images/desti5.webp') }}" alt=""></div>
            <h4>New Zealand</h4>
        </div>
        <div class="destBoxes">
            <div class="BoxImg"><img src="{{ asset('assets/front/images/desti6.webp') }}" alt=""></div>
            <h4>South Africa</h4>
        </div>

    </div>
</div>

<div class="blogSection">
    <h3>Read more about New Zealand on our blog</h3>
    <div class="blog-container">
        <div class="blog-card">
            <img src="{{ asset('assets/front/images/blog1.webp') }}" alt="Route 66 Road" class="blog-image" />
            <div class="blog-content">
                <p class="blog-category">BLOG</p>
                <h3 class="blog-title">New Zealand: What...</h3>
                <p class="blog-time">3 min read</p>
            </div>
        </div>
        <div class="blog-card">
            <img src="{{ asset('assets/front/images/blog2.webp') }}" alt="Route 66 Road" class="blog-image" />
            <div class="blog-content">
                <p class="blog-category">BLOG</p>
                <h3 class="blog-title">4 fabulous reasons...</h3>
                <p class="blog-time">3 min read</p>
            </div>
        </div>
        <div class="blog-card">
            <img src="{{ asset('assets/front/images/blog3.webp') }}" alt="Route 66 Road" class="blog-image" />
            <div class="blog-content">
                <p class="blog-category">BLOG</p>
                <h3 class="blog-title">Cruise & Tour...</h3>
                <p class="blog-time">3 min read</p>
            </div>
        </div>

    </div>
</div>

<div class="userDet">
    <div class="userInput">
        <div class="newsletter-section">
            <h3>Receive inspiration in your inbox</h3>
            <p>Subscribe to our newsletter for holiday inspiration and the latest special offers</p>

            <form class="newsletter-form">
                <div class="input-det-wrapper">
                    <div class="input-group">
                        <div class="input-container">
                            <label for="first-name">First name</label>
                            <input type="text" id="first-name" name="first-name">
                        </div>
                        <div class="input-container">
                            <label for="last-name">Last name</label>
                            <input type="text" id="last-name" name="last-name">
                        </div>
                    </div>

                    <div class="input-container full-width">
                        <label for="email">Email</label>
                        <input type="email" id="email" name="email">
                    </div>
                </div>

                <button type="submit" class="submit-button">Submit</button>
            </form>

            <p class="privacy-text">For more information about how we use your personal information, please view our <a href="#">Privacy Policy</a>.</p>
        </div>

    </div>
</div>

<div class="whyChooseUs">
    <div class="usContainer">
        <h3>Why choose a Titan tour?</h3>
        <p>Titan Travel have always been about seeing more and doing more – which is why we meticulously plan our award-winning escorted tours so that our expertly crafted itineraries make sure that so much is included. Once you book your holiday, you can relax knowing that every element has been taken care of. Choose the tour that gives you more.</p>

        <div class="highlights">
            <div class="highlightBox">
                <img src="{{ asset('assets/front/svg/bus.svg') }}" alt="">
                <h4>VIP travel Services</h4>
                <p>Smooth transfers to and from home with unlimited mileage</p>
            </div>
            <div class="highlightBox">
                <img src="{{ asset('assets/front/svg/star.svg') }}" alt="">
                <h4>More value</h4>
                <p>From excursions to hotels, entry tickets and dining packages, we include more than any other tour.</p>
            </div>
            <div class="highlightBox">
                <img src="{{ asset('assets/front/svg/user.svg') }}" alt="">
                <h4>More knowledgeable</h4>
                <p>Be guided by some of the most passionate and knowledgeable tour managers in the world, on hand to help every step of the way.</p>
            </div>
            <div class="highlightBox">
                <img src="{{ asset('assets/front/svg/plus.svg') }}" alt="">
                <h4>More flexible</h4>
                <p>Feel free to amend or extend your travel plans, up until final payment, and enjoy free time on your tour with us too.</p>
            </div>
        </div>
    </div>
</div>
@endsection
@push('javascript')
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

<script src="{{ asset('assets/front/js/usascript.js') }}"></script>
<script>
    var swiper = new Swiper(".mySwiper", {
        slidesPerView: 'auto',
        spaceBetween: -20,
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
    });
</script>
@endpush