@php
$user = \Auth::user();
@endphp
@extends('layouts.main')
@push('css')
<link rel="stylesheet" href="{{ asset('assets/front/css/usa.css') }}">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
<link rel="stylesheet" href="{{ asset('assets/front/css/swiper.css') }}">

@endpush

@section('content')
<div class="content-wrapper">
        <!-- <div class="breadcrum">
            <a href=""><h3>Home /</h3></a>
            <a href=""><h3>Destinations /</h3></a>
            <a href=""><h3>Canada</h3></a>
        </div> -->

        <div class="banner">
            <h1>incredible <span>Canada</span> tours</h1>
            <img src="{{ asset('assets/front/images/canada-BG.webp') }}" alt="">
        </div>

         <div class="country-banner-slider">
                <div class="banner-text-cont">
                    <div class="iamge-slider">
                        <div class="swiper mySwiper">
                            <div class="swiper-wrapper">
                              <div class="swiper-slide"><img src="{{ asset('assets/front/images/slider1.webp') }}" alt=""></div>
                              <div class="swiper-slide"><img src="{{ asset('assets/front/images/slider2.webp') }}" alt=""></div>
                              <div class="swiper-slide"><img src="{{ asset('assets/front/images/slider3.webp') }}" alt=""></div>
                              <div class="swiper-slide"><img src="{{ asset('assets/front/images/slider4.webp') }}" alt=""></div>
                              <div class="swiper-slide"><img src="{{ asset('assets/front/images/slider5.webp') }}" alt=""></div>
                            </div>
                          </div>
                        
                    </div>

                    <div class="text-content">
                        <p id="text">
                            The second-biggest country in the world is vast – and incredibly varied - and on our Canada tours you can experience it all. We can take you to the wilds of the Rocky Mountains, lead you through the streets of Toronto, Montréal and Vancouver, show you Nova Scotia’s charms, and introduce you to the rolling landscapes of the prairie provinces.
                            
                            <span id="ellipsis">...</span>
                            <span id="extraText" style="display: none;">
                                With so much to offer, it can be hard to know where to start – luckily, we know just how to get the most out of a trip here. We’ve got more than a dozen different escorted holidays to Canada to choose between, from cross-country rail holidays to Cruise & Tour itineraries, all carefully designed by our team of specialists.

                                The awe-inspiring peaks of the Canadian Rockies are always a popular choice, and can easily be combined with time in Vancouver or a cruise along the coastlines of British Columbia and Alaska. For added luxury, choose an itinerary that includes a journey on the famous Rocky Mountaineer train.

                                In the east, you’ve got big cities, French flair and the spectacular Niagara Falls to discover, plus the quaint fishing villages and clapboard houses of the Maritimes. It’s also possible to pair eastern Canada with the US, exploring beautiful Boston and Maine.
                            </span>
                        </p>
                        <button id="readMoreBtn">Read more <span>▼</span></button>
                    </div>
                </div>
        </div>      
    </div>

    <div class="expert-opinion">
       <div class="expert-wrapper">
        <div class="profile-section">
            <img src="{{ asset('assets/front/images/canada-exp.webp') }}" alt="Profile Image" class="profile-image">
            <h3> Hercules Zeris </h3>
            <p>Product Manager</p>
        </div>
        <div class="content-section">
            <h2>What our experts love about Canada</h2>
            <p>
                Whatever your favourite kind of animal - birdlife, ocean dwelling creatures or large mammals - you’re sure to spot something on your wishlist in Canada. From bears to bald eagles, hummingbirds to humpback whales, and marmots to moose, the list is endless.
            </p>
        </div>
       </div>
    </div>


    <div class="best-places">
        <div class="best-places-container">
            <h3>What are the best places to visit in the Canada?</h3>
            <p>Coast or city? Mountains or Maritimes? It can be hard to decide where to go (and what to do) on a trip to Canada - use our at-a-glance guide to help you narrow down which areas to include on your adventure.</p>


            <div class="placeBox">
                <div class="boxText">
                    <h4>Canadian Rockies</h4>
                    <p>The sprawling Canadian Rockies, running through the provinces of Alberta and British Columbia, are one of Canada's showpiece attractions. As a holiday destination, the Rockies are without equal: a photogenic mix of towering snow-capped peaks, forest-cloaked canyons and wide-open vistas. Particular highlights of our Canadian touring holidays here include mighty Athabasca Glacier</p>
                    
                    <!-- <button class="explore-button">
                        Explore more <span><img src="{{ asset('assets/front/images/right.png') }}" alt=""></span>
                    </button> -->
                </div>
                <div class="imgBox">
                   <img src="{{ asset('assets/front/images/card5.jpg') }}" alt="">
                </div>
            </div>

            <div class="placeBox">
                <div class="imgBox">
                    <img src="{{ asset('assets/front/images/card6.jpg') }}" alt="">
                 </div>
                <div class="boxText">
                    <h4>Rocky Mountaineer</h4>
                    <p>The Rocky Mountaineer train is a quintessential Canadian adventure - you'll experience the Rockies from the comfort of plush carriages fitted with panoramic observation windows, while enjoying fine food and drink and the benefit of knowledgeable onboard Hosts. The tracks carve a scenic route from Banff to Vancouver, with an overnight stop at Kamloops en route</p>
                    
                    <!-- <button class="explore-button">
                        Explore more <span><img src="{{ asset('assets/front/images/right.png') }}" alt=""></span>
                    </button> -->
                </div>
                
            </div>

            <div class="placeBox">
                <div class="boxText">
                    <h4>British Columbia & Alaskan cruises</h4>
                    <p>Known as the ‘Golden State’, California attracts visitors from all across the world. California, along with its neighbouring states, Nevada and Arizona, conjures images of the romantic Wild West, and our California and the Golden West tour (one of our most popular trips to America) aims to keep that Frontier spirit alive. The tour starts in LA and San Diego, before turning inland, where Yosemite.</p>
                    
                    <!-- <button class="explore-button">
                        Explore more <span><img src="{{ asset('assets/front/images/right.png') }}" alt=""></span>
                    </button> -->
                </div>
                <div class="imgBox">
                   <img src="{{ asset('assets/front/images/card7.jpg') }}" alt="">
                </div>
            </div>

            <div class="placeBox">
                <div class="imgBox">
                    <img src="{{ asset('assets/front/images/card8.jpg') }}" alt="">
                 </div>
                <div class="boxText">
                    <h4>Eastern Canada</h4>
                    <p>Ontario and Québec each present their own particular flavour of Canadian culture and history. Climb Toronto's CN Tower, explore Ottawa's stately Parliament Hill or stroll the walled Québec City, complete with historic fort and defensive cannons. Canada's eastern provinces are also a showcase of natural spectacles. Ontario is home to a staggering quarter of a million lakes, as well as the mighty Niagara Falls, which straddle the border between Canada and the US. Holidays here can be combined with the Canadian Rockies, travelling between the two regions either by train or plane, or with the north-eastern US states.</p>
                    
                    <!-- <button class="explore-button">
                        Explore more <span><img src="{{ asset('assets/front/images/right.png') }}" alt=""></span>
                    </button> -->
                </div>
                
            </div>

            <div class="placeBox">
                <div class="boxText">
                    <h4>Atlantic Canada</h4>
                    <p>Our Atlantic Canada tours cover the provinces of Newfoundland and Labrador, and Nova Scotia, and offer travellers a completely different experience to what you'd expect in the rest of the country. The region is a treat for wildlife enthusiasts - keep a look out for whales, bears and thousands of nesting puffins - while foodies will revel in the fresh and abundant seafood, from succulent oysters to delicious lobster, scallops and mussels. There's plenty of history to uncover, too, from Viking settlements to a surprising aviation heritage.</p>
                    
                    <!-- <button class="explore-button">
                        Explore more <span><img src="{{ asset('assets/front/images/right.png') }}" alt=""></span>
                    </button> -->
                </div>
                <div class="imgBox">
                   <img src="{{ asset('assets/front/images/card9.jpg') }}" alt="">
                </div>
            </div>
        </div>

    </div>


    <div class="recommendation-box">
        <h3>Recommended Canada  holidays</h3>
        <div class="re-wrapper">
            <div class="travel-card">
                <div class="card-image">
                  <img src="{{ asset('assets/front/images/travel1.webp') }}" alt="Southern Sights and Sounds" />
                </div>
                <div class="travContent">
                    <div class="card-content">
                        <h2>Deluxe Alaskan Voyage and Rocky Mountaineer</h2>
                        <p class="location"><span>&#x1F4CD;</span> USA</p>
                        <ul>
                          <li>● 9 nights in hotels, 7 nights cruise on Koningsdam and 1 in flight</li>
                          <li>● 26 meals included</li>
                          <li>● 15 excursions & visits</li>
                          <li>● Titan's VIP door-to-door travel service</li>
                        </ul>
                    </div>
                    <div>
                        <p class="duration-price">
                            <span class="duration">18 days</span> from <span class="price">£6,545pp</span>
                          </p>
                          <button class="holiday-button">
                              Holiday details <span>&#8594;</span>
                            </button>
                    </div>
                </div>
              </div>
            <div class="travel-card">
                <div class="card-image">
                  <img src="{{ asset('assets/front/images/travel2.webp') }}" alt="Southern Sights and Sounds" />
                </div>
                <div class="travContent">
                    <div class="card-content">
                        <h2>California and the Golden West</h2>
                        <p class="location"><span>&#x1F4CD;</span> USA</p>
                        <ul>
                          <li>● 12 nights in hotels and 1 in flight</li>
                          <li>● 2 meals included</li>
                          <li>● 7 excursions & visits</li>
                          <li>● Titan's VIP door-to-door travel service</li>
                        </ul>
                    </div>
                    <div>
                        <p class="duration-price">
                            <span class="duration">14 days</span> from <span class="price">£3,895pp</span>
                          </p>
                          <button class="holiday-button">
                              Holiday details <span>&#8594;</span>
                            </button>
                    </div>
                </div>
              </div>
            <div class="travel-card">
                <div class="card-image">
                  <img src="{{ asset('assets/front/images/travel3.webp') }}" alt="Southern Sights and Sounds" />
                </div>
                <div class="travContent">
                    <div class="card-content">
                        <h2>Deluxe Alaskan Voyage and Rocky Mountaineer</h2>
                        <p class="location"><span>&#x1F4CD;</span> USA</p>
                        <ul>
                          <li>● 9 nights in hotels and 1 in flight</li>
                          <li>● 5 meals included</li>
                          <li>● 6 excursions & visits</li>
                          <li>● Titan's VIP door-to-door travel service</li>
                        </ul>
                    </div>
                    <div>
                        <p class="duration-price">
                            <span class="duration">14 days</span> from <span class="price">£4,795pp</span>
                          </p>
                          <button class="holiday-button">
                              Holiday details <span>&#8594;</span>
                            </button>
                    </div>
                </div>
              </div>
              
        </div>
    </div>

    <div class="video">
        <h3>Find out more</h3>
        <div class="video-container">
            <iframe
            width="560"
            height="315"
            src="https://www.youtube.com/embed/-xBKKbHaNBc?start=1"
            title="YouTube video player"
            frameborder="0"
            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
            allowfullscreen
        ></iframe>
        
          </div>
          
          
    </div>

    <div class="faq">
        <h3>More information about Canada</h3>
       <div class="faqwrapper">
        <button class="accordion">Why should you holiday in Canada with Titan?<img class="faqArrow" src="{{ asset('assets/front/images/downArrow.png') }}" alt=""></button>
        <div class="panel">
            <p>Each of our Canada holidays includes our VIP door-to-door travel service to take you to your chosen UK airport, plus an expert tour manager on hand to keep everything running smoothly while you’re away.</p>
            <br>
            <p>Although many excursions are included in the price already, our selection of optional excursions can help you get even more out of your holiday, whether it’s a whale-watching tour or a side-trip to Niagara Falls.</p>
        </div>
        <button class="accordion">When is the best time to visit Canada? <img class="faqArrow" src="{{ asset('assets/front/images/downArrow.png') }}" alt=""></button>
        <div class="panel">
            <p>Our Canada escorted tours depart across spring, summer and autumn, avoiding the cold weather and often heavy snowfall that much of the country experiences during winter. The summer months are great for whale watching on both coasts and wildlife spotting in the Rockies, while spring and autumn tend to be cooler but much less crowded in the most popular destinations.</p>
        </div>
        <button class="accordion">What are the hotel options on your Canadian tours?<img class="faqArrow" src="{{ asset('assets/front/images/downArrow.png') }}" alt=""></button>
        <div class="panel">
            <p>The hotels we feature have all been hand-selected by our team to give you the best possible experience. If you take a look at the itineraries for each of our Canada tour packages, you’ll see the hotel names listed for each night of the tour.
                &nbsp;&nbsp;</p>
        </div>

        <button class="accordion">What is the food and drink like in Canada?<img class="faqArrow" src="{{ asset('assets/front/images/downArrow.png') }}" alt=""></button>
        <div class="panel">
            <p><span>There's a huge variety of different dishes and flavours to try, from French cuisine in Quebec to seafood in Nova Scotia to Asian fusion on the west coast.</span></p> <br>
            <p><span>Must-try dishes include poutine (chips topped with gravy and cheese curds - Canadian fast food at its finest); pancakes served with bacon and drizzled with maple syrup; sweet, flaky butter tarts; and freshly caught salmon.</span></p> <br>

            <p><span>Wines are primarily produced in Ontario and British Columbia and are well worth trying. Look out for ice wine, too, made from grapes which have frozen on the vine during Canada's cold winter months.</span></p>
        </div>
        <button class="accordion">Do you need a visa for Canada?<img class="faqArrow" src="{{ asset('assets/front/images/downArrow.png') }}" alt=""></button>
        <div class="panel">
            <p><span>Visa requirements for Canada holidays vary depending on the passport you hold and the length of time you’re planning on staying. For the most up-to-date information on visas, please use the quick-check tool on our visa requirements page.</a><span>.&nbsp;</span></p>
        </div>
       </div>
          
    </div>

    <div class="otherDestination">
        <h3>Other popular <br> destinations</h3>
        <div class="destinationContainer">
            <div class="destBoxes">
                    <div class="BoxImg"><img src="{{ asset('assets/front/images/desti1.webp') }}" alt=""></div>
                    <h4>Alaska</h4>
            </div>
            <div class="destBoxes">
                    <div class="BoxImg"><img src="{{ asset('assets/front/images/desti2.webp') }}" alt=""></div>
                    <h4>Australia</h4>
            </div>
            <div class="destBoxes">
                    <div class="BoxImg"><img src="{{ asset('assets/front/images/desti3.webp') }}" alt=""></div>
                    <h4>Canada</h4>
            </div>
            <div class="destBoxes">
                    <div class="BoxImg"><img src="{{ asset('assets/front/images/desti4.webp') }}" alt=""></div>
                    <h4>Mexico</h4>
            </div>
            <div class="destBoxes">
                    <div class="BoxImg"><img src="{{ asset('assets/front/images/desti5.webp') }}" alt=""></div>
                    <h4>New Zealand</h4>
            </div>
            <div class="destBoxes">
                    <div class="BoxImg"><img src="{{ asset('assets/front/images/desti6.webp') }}" alt=""></div>
                    <h4>South Africa</h4>
            </div>
            
        </div>
    </div>

    <div class="blogSection">
        <h3>Read more about Canada on our blog</h3>
        <div class="blog-container">
            <div class="blog-card">
                <img src="{{ asset('assets/front/images/blog1.webp') }}" alt="Route 66 Road" class="blog-image" />
                <div class="blog-content">
                    <p class="blog-category">BLOG</p>
                    <h3 class="blog-title">Canada: What...</h3>
                    <p class="blog-time">3 min read</p>
                </div>
            </div>
            <div class="blog-card">
                <img src="{{ asset('assets/front/images/blog2.webp') }}" alt="Route 66 Road" class="blog-image" />
                <div class="blog-content">
                    <p class="blog-category">BLOG</p>
                    <h3 class="blog-title">4 fabulous reasons...</h3>
                    <p class="blog-time">3 min read</p>
                </div>
            </div>
            <div class="blog-card">
                <img src="{{ asset('assets/front/images/blog3.webp') }}" alt="Route 66 Road" class="blog-image" />
                <div class="blog-content">
                    <p class="blog-category">BLOG</p>
                    <h3 class="blog-title">Cruise & Tour...</h3>
                    <p class="blog-time">3 min read</p>
                </div>
            </div>
            
        </div>
    </div>

    <div class="userDet">
        <div class="userInput">
            <div class="newsletter-section">
                <h3>Receive inspiration in your inbox</h3>
                <p>Subscribe to our newsletter for holiday inspiration and the latest special offers</p>
                
                <form class="newsletter-form">
                    <div class="input-det-wrapper">
                        <div class="input-group">
                            <div class="input-container">
                                <label for="first-name">First name</label>
                                <input type="text" id="first-name" name="first-name">
                            </div>
                            <div class="input-container">
                                <label for="last-name">Last name</label>
                                <input type="text" id="last-name" name="last-name">
                            </div>
                        </div>
                        
                        <div class="input-container full-width">
                            <label for="email">Email</label>
                            <input type="email" id="email" name="email">
                        </div>
                    </div>
                    
                    <button type="submit" class="submit-button">Submit</button>
                </form>
                
                <p class="privacy-text">For more information about how we use your personal information, please view our <a href="#">Privacy Policy</a>.</p>
            </div>
            
        </div>
    </div>

    <div class="whyChooseUs">
        <div class="usContainer">
            <h3>Why choose a Titan tour?</h3>
            <p>Titan Travel have always been about seeing more and doing more – which is why we meticulously plan our award-winning escorted tours so that our expertly crafted itineraries make sure that so much is included. Once you book your holiday, you can relax knowing that every element has been taken care of. Choose the tour that gives you more.</p>

            <div class="highlights">
                <div class="highlightBox">
                    <img src="{{ asset('assets/front/svg/bus.svg') }}" alt="">
                    <h4>VIP travel Services</h4>
                    <p>Smooth transfers to and from home with unlimited mileage</p>
                </div>
                <div class="highlightBox">
                    <img src="{{ asset('assets/front/svg/star.svg') }}" alt="">
                    <h4>More value</h4>
                    <p>From excursions to hotels, entry tickets and dining packages, we include more than any other tour.</p>
                </div>
                <div class="highlightBox">
                    <img src="{{ asset('assets/front/svg/user.svg') }}" alt="">
                    <h4>More knowledgeable</h4>
                    <p>Be guided by some of the most passionate and knowledgeable tour managers in the world, on hand to help every step of the way.</p>
                </div>
                <div class="highlightBox">
                    <img src="{{ asset('assets/front/svg/plus.svg') }}" alt="">
                    <h4>More flexible</h4>
                    <p>Feel free to amend or extend your travel plans, up until final payment, and enjoy free time on your tour with us too.</p>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('javascript')
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

<script src="{{ asset('assets/front/js/usascript.js') }}"></script>
<script>
    var swiper = new Swiper(".mySwiper", {
        slidesPerView: 'auto',
        spaceBetween: -20,
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
    });
</script>
@endpush