@extends('layouts.app')

@section('content')

<section class="section">
  <div class="container mt-5">
    <div class="row">
      <div class="col-12 col-sm-8 offset-sm-2 col-md-6 offset-md-3 col-lg-6 offset-lg-3 col-xl-4 offset-xl-4">
        <div class="login-brand">
          <img src="{{ asset('assets/front/img/Exodus-Logo-01.png') }}" alt="logo" width="100" class="shadow-light ">
        </div>

        <div class="card card-primary">
          <div class="card-header">
            <h4>Login</h4>
          </div>

          <div class="card-body">
            <form method="POST" action="{{ route('login') }}">
              @csrf
              <div class="form-group">
                <label for="email">Email</label>
                <input id="email" type="text" class="form-control " name="email_or_username" value="{{ old('email') }}" required autocomplete="email" autofocus>

                <div class="invalid-feedback">
                  Please fill in your email
                </div>
              </div>

              <div class="form-group">
                <div class="d-block">
                  <label for="password" class="control-label">Password</label>
                  <div class="float-right">

                  </div>
                </div>
                <input id="password" type="password" class="form-control " name="password" required autocomplete="current-password">
                <div class="invalid-feedback">
                  please fill in your password
                </div>
              </div>

              <div class="form-group">
                <div class="custom-control custom-checkbox">
                  <input type="checkbox" name="remember" class="custom-control-input" tabindex="3" id="remember-me">
                  <label class="custom-control-label" for="remember-me">Remember Me</label>
                </div>
              </div>

              <div class="form-group">
                <button type="submit" class="btn btn-primary btn-lg btn-block" tabindex="4">
                  Login
                </button>

              </div>
            </form>



          </div>
        </div>
        <div class="mt-5 text-muted text-center">
          {{-- Don't have an account? <a href="{{route('register')}}">Create One</a> --}}
        </div>
        <div class="simple-footer">
          Copyright &copy; Nexprism 2018
        </div>
      </div>
    </div>
  </div>
</section>
@endsection
@push('javascript')
<script>
  @if(session('errors'))
  iziToast.error({
    title: "{{ __('Error!') }}",
    message: "{{ session('errors')->first() }}",
    position: 'topRight'
  });
  @endif

  @if(session('error'))
  iziToast.error({
    title: "{{ __('Error!') }}",
    message: "{{ session('error') }}",
    position: 'topRight'
  });
  @endif
</script>
@endpush