<?php
// app/Rules/ValidRedemptionPin.php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;
use App\Models\Redemption;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class ValidRedemptionPin implements Rule
{
    public function passes($attribute, $value)
    {
        // Perform validation logic to check if the redemption pin is valid
        return User::where('id',Auth::user()->id)->where('redemption_pin', $value)->exists();
    }

    public function message()
    {
        return 'The redemption pin is invalid.';
    }
}

?>