<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RatingHistory extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'journey_id',
        'rating',
        'commission',
        'status'
    ];

    public function journeyDetails()
    {
        return $this->belongsTo(TravelJourney::class, 'journey_id');
    }
    public function userDetails()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
