<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    public function login(Request $request)
    {
        // dd($request->all());
        $emailOrUsername = $request->email_or_username;
        $user = User::where(function ($query) use ($emailOrUsername) {
            $query->where('email', $emailOrUsername)
                ->orWhere('username', $emailOrUsername);
        })->first();
        // dd($user);
        if (!empty($user)) {
            if ($user->type == 'Super Admin') {
                $credentials = $request->only('email_or_username', 'password');

                // Determine if the input is an email or username
                $fieldType = filter_var($credentials['email_or_username'], FILTER_VALIDATE_EMAIL) ? 'email' : 'username';

                // Add the determined field type to the credentials array
                $credentials[$fieldType] = $credentials['email_or_username'];
                unset($credentials['email_or_username']);

                if (Auth::attempt($credentials)) {
                    $user = User::find(Auth::user()->id);
                    // dd($user);
                    $user->last_login = now();
                    $user->save();
                    return redirect()->route('home');
                } else {
                    return redirect()->back()->with('error', __('Invalid username or password'));
                }
            } elseif (!empty($user->id)) {



                $user = User::where(function ($query) use ($emailOrUsername) {
                    $query->where('email', $emailOrUsername)
                        ->orWhere('username', $emailOrUsername);
                })->first();

                $credentials = $request->only('email_or_username', 'password');

                // Determine if the input is an email or username
                $fieldType = filter_var($credentials['email_or_username'], FILTER_VALIDATE_EMAIL) ? 'email' : 'username';

                // Add the determined field type to the credentials array
                $credentials[$fieldType] = $credentials['email_or_username'];
                unset($credentials['email_or_username']);
                if (Auth::attempt($credentials)) {
                    $user = User::find(Auth::user()->id);
                    $user->last_login = now();
                    $user->save();
                    return redirect()->route('front');
                } else {
                    return redirect()->back()->with('error', __('Invalid username or password'));
                }
            } else {

                return redirect()->back()->with('error', __('permission denied'));
            }
        } else {
            return redirect()->back()->with('error', __('user not found'));
        }
    }
}
