<?php

namespace App\DataTables;

use App\Facades\UtilityFacades;
use App\Models\User;
use Illuminate\Http\Request;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;

class UsersDataTable extends DataTable
{
    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        return datatables()
            ->eloquent($query)
             ->addColumn('referral_by', function (User $user) {
                return $user->referral_by. ' - '.$user->referrer->username;
             })
            ->addColumn('role', function (User $user) {
                $out = '';
                if (!empty($user->getRoleNames())) {
                    foreach ($user->getRoleNames() as $v) {

                        $out = '<label class="badge badge-primary">' . $v . '</label>';
                    }
                }
                return $out;
            })
            ->editColumn('last_login', function (User $user) {
                return UtilityFacades::date_time_format($user->last_login);
            })
            ->editColumn('number_of_journey', function (User $user) {
                if($user->level != ''){
                $field = 'level_' . $user->level . '_jorney';
                // dd($field);
                return UtilityFacades::getsettings($field);
                }else{
                    return 40;
                }
            })
            ->addColumn('action', function (User $user) {
                return view('users.action', compact('user'));
            })

            ->rawColumns(['role', 'action']);
       
    }

    /**
     * Get query source of dataTable.
     *
     * @param \App\User $model
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(User $model, Request $request)
    {

        $users =  $model->newQuery()->where('type','User');
        if ($request->username) {
            $users->where('username', 'like', '%' . $request->username . '%');
        }
        if ($request->mobile_number) {
            $users->where('mobile_number', 'like', '%' . $request->mobile_number . '%');
        }
        if ($request->r_date) {
            // dd($request->r_date);
            $users->whereDate('created_at', '=', $request->r_date);
        }
        return $users;
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
            ->setTableId('users-table')
            ->columns($this->getColumns())
            ->minifiedAjax()
            ->orderBy(1)
            ->language([
                "paginate" => [
                    "next" => '<i class="fas fa-angle-right"></i>',
                    "previous" => '<i class="fas fa-angle-left"></i>'
                ]
            ])
            ->parameters([
                "scrollX" => true
            ]);
    }

    /**
     * Get columns.
     *
     * @return array
     */
    protected function getColumns()
    {
        return [
            
            Column::make('id'),
            Column::make('username'),
            Column::make('balance'),
            Column::make('visited_journey'),
            Column::make('number_of_journey'),
            Column::make('level'),
            Column::make('total_commission'),
            Column::make('referral_by'),
            Column::make('mobile_number'),
            Column::make('referral_code'),
            Column::make('last_login'),
            
            Column::computed('action')
                ->exportable(false)
                ->printable(false)
                ->width(120)
                ->addClass('text-center'),
        ];
    }

    /**
     * Get filename for export.
     *
     * @return string
     */
    // protected function filename()
    // {
    //     return 'Users_' . date('YmdHis');
    // }
}
